/*
 *  SimpleVector.h
 *  Pirates2011
 *
 *  Created by Alan Dorin on 25/03/11.
 *  Copyright 2011 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef _CLS_SimpleVector_
#define _CLS_SimpleVector_

#define vX		0
#define vY		1
#define vZ		2
#define vXYZ	3

#include <iostream>

class SimpleVector {
    private:
		double mag;																// double magnitude b/c v[XYZ] are doubles
	
    public:
		static const double ZERO_SimpleVector_MAGNITUDE;
		double v[vXYZ];

		SimpleVector (void);
		SimpleVector (double a);
		SimpleVector (double a, double b, double c);
		SimpleVector (const SimpleVector& source);
		~SimpleVector();
		
		void output(void) const;
		void output(std::ostream& outFile, bool commasOn=false) const;
		
		void set(double a, double b, double c);										// set vector components separately
		void setZero(void);
		void set(double a);															// set vector components equivalently
		
		void vector_gl_colour(void) const;											// gl colour call for vector
		void vector_gl_v3(void)	const;												// glVertex3dv() call for vector
		void vector_gl_translate(void) const;										// gl translate call for vector									

		int	equalZero (void) const;													// is vector a zero vector?
		double	magnitude (void) const;												// length of v

		SimpleVector	unit (void) const;													// (normalized) unit vector
		
		SimpleVector	operator- (void) const;												// antiparallel vector (ie. -ve each component)
		SimpleVector	operator- (const SimpleVector& w) const;									// difference b/n v & w
		SimpleVector	operator+ (const SimpleVector& w) const;									// sum of v & w
		SimpleVector	operator* (double s) const;											// scalar mult. v*s
		SimpleVector	operator/ (double s) const;											// scalr div. v/s
		SimpleVector&	operator= (const SimpleVector& w);										// assignment op.
		
		friend std::ostream& operator<< (std::ostream& outFile, const SimpleVector& theVector);
		friend std::istream& operator>> (std::istream& inFile, SimpleVector& theVector);
		friend bool operator== (const SimpleVector& v, const SimpleVector& w);
};

#endif

